Attribute VB_Name = "CtrlCard"
'********************** Motion control module ********************
'For simplicity, quickly and easily develop a common good, scalable,
'easy maintenance of applications, we have the basis for control ofthe library card will be
' all library functions were classified package. The following example uses a motion
'control card
'**************************************** ****************

Public Result As Integer      'Return Value

Const MAXAXIS = 6           'Maximum number of axes

'******************* Initialization function ************************
'the function contains commonly used to control the card initialization library function, which is called
'the basis of other functions, it must first call in the example program
' return value <= 0 initialization failed, the return value> 0 indicates the beginning of the successful start

'*****************************************************
Public Function Init_Card() As Integer
       
    Result = adt8960_initial           'Card initialization
    
    If Result <= 0 Then
     
       Init_Card = Result
       
       Exit Function
       
    End If
    
    For i = 1 To MAXAXIS
       
       set_command_pos 0, i, 0         'Logical position counter is cleared
       
       set_actual_pos 0, i, 0          'Real position counter clear bit
       
       set_startv 0, i, 1000            'Set the initial speed
       
       set_speed 0, i, 2000             'Set the drive speed
       
       set_acc 0, i, 625               'Set Acceleration
     
    Next i
    
    Init_Card = Result
       
End Function

'******************** Get version information ************************ '
' This function is used to obtain library version of '
' Parameters: libver - library version number
'
'*********************************************************
Public Function Get_Version(libver As Double) As Single

    
   libver = get_hardware_ver(0)
    
End Function

'********************** Set the speed module ***********************
' based on the value of the parameters to determine acceleration and deceleration is uniform or
'set the initial shaft speed, drive speed and acceleration
' parameter: axis - axis No.
'StartV - initial velocity
' Speed - drive speed
'Add - Acceleration
' return value = 0 correct error return value = 1

'*********************************************************
Public Function Setup_Speed(ByVal axis As Integer, ByVal startv As Long, ByVal speed As Long, ByVal add As Long, ByVal mode As Integer) As Integer

        If (startv - speed >= 0) Then           'Make uniform
        
            Result = set_startv(0, axis, startv)
        
            set_speed 0, axis, startv
                        
        Else
        
             Select Case mode
            
          Case 0                                 'Trapezoidal acceleration and deceleration
           
             set_ad_mode 0, axis, 0              'Set to linear acceleration and deceleration mode

        
             Result = set_startv(0, axis, startv)
        
             set_speed 0, axis, speed
         
             set_acc 0, axis, add / 125
            
          Case 1                               'S-type acceleration and deceleration
            
             Dim time As Double                'The definition of time
                 
             Dim addvar As Double              'Acceleration of the rate of change
                 
             Dim k As Long                     'The results to be calculated
               
             time = (speed - startv) / (add / 2) 'The acceleration time

             addvar = add / (time / 2)           'Acceleration of the rate of change

             k = 1000000 / addvar
             
             set_ad_mode 0, axis, 1                'Set 1: S curve acceleration and deceleration mode
             
             set_startv 0, axis, startv / ratio
             
             set_speed 0, axis, speed / ratio
        
             set_acc 0, axis, add / 125 / ratio
        
             set_acac 0, axis, k
             
         End Select
            
        End If
   
    
End Function

'********************* Axis drive functions **********************
'the function is used to drive a single movement axis
'parameter: axis-axis number, pulse-output pulse number
' return value = 0 correct, an error return value = 1
'*******************************************************
Public Function Axis_Pmove(ByVal axis As Integer, ByVal pulse As Long) As Integer
    
    Result = pmove(0, axis, pulse)
    
    Axis_Pmove = Result
    
End Function
'************************ Uniaxial continuous drive function ******************** ***
'This function is used to drive a single movement axis
' parameter: axis-axis number, value-pulse direction
' return value = 0 correct, an error return value = 1
'***********************************************************/
Public Function Axis_ConMove(ByVal axis As Integer, ByVal dir As Long) As Integer

    Result = continue_move(0, axis, dir)
    
    Axis_ConMove = Result
    
End Function

'******************* Any two axis interpolation function ********************
'This function is used to drive any two axes interpolated motion
'parameter: axis1, axis2 - in the axis interpolation No.
' pulse1, pulse2-axis of the output pulse corresponding to the number of
'return value = 0 correct, an error return value = 1
'*******************************************************
Public Function Interp_Move2(ByVal axis1 As Integer, ByVal axis2 As Integer, ByVal pulse1 As Long, ByVal pulse2 As Long) As Integer

    Result = inp_move2(0, axis1, axis2, pulse1, pulse2)
    
    Interp_Move2 = Result
    
End Function

'*******************岹********************

    'úв岹˶
    
    ':     axis1 , axis2,axis3 - 岹
    
    '          pulse1,pulse2,pulse3-Ӧ
    
    'ֵ=0ȷֵ=1

'*******************************************************

Public Function Interp_Move3(ByVal axis1 As Integer, ByVal axis2 As Integer, ByVal axis3 As Integer, ByVal pulse1 As Long, ByVal pulse2 As Long, ByVal pulse3 As Long) As Integer

    Result = inp_move3(0, axis1, axis2, axis3, pulse1, pulse2, pulse3)
    
    Interp_Move3 = Result
    
End Function


'******************* Axis interpolation function ********************
'This function is used interpolate any axis drive campaign
'parameter: axis1, axis2, axis3, axis4-participation axis interpolation No.
' pulse1, pulse2, pulse3, pulse4 - the number of pulses corresponding to the output shaft
'return value = 0 is correct, return value = 1 Error

'*******************************************************
Public Function Interp_Move4(ByVal axis1 As Integer, ByVal axis2 As Integer, ByVal axis3 As Integer, ByVal axis4 As Integer, ByVal pulse1 As Long, ByVal pulse2 As Long, ByVal pulse3 As Long, ByVal pulse4 As Long) As Integer
    
    Result = inp_move4(0, axis1, axis2, axis3, axis4, pulse1, pulse2, pulse3, pulse4)
    
    Interp_Move4 = Result
    
End Function


'******************* Five-axis interpolation function ********************
'This function is used interpolate any five-axis motion-driven
'parameters: axis1, axis2, axis3, axis4, axis5-axis interpolation in number
' pulse1, pulse2, pulse3, pulse4, pulse5-axis of the output pulse corresponding to the number of
'correct return value = 0 , the return value = 1 error
'*******************************************************
Public Function Interp_Move5(ByVal axis1 As Integer, ByVal axis2 As Integer, ByVal axis3 As Integer, ByVal axis4 As Integer, ByVal axis5 As Integer, ByVal pulse1 As Long, ByVal pulse2 As Long, ByVal pulse3 As Long, ByVal pulse4 As Long, ByVal pulse5 As Long) As Integer
    
    Result = inp_move5(0, axis1, axis2, axis3, axis4, axis5, pulse1, pulse2, pulse3, pulse4, pulse5)
    
    Interp_Move5 = Result
    
End Function


'*******************岹********************

    'úв岹˶
    
    ':
    
    '   pulse1 , pulse2, pulse3, pulse4 ,pulse5, pulse6- Ӧ
    
    'ֵ=0ȷֵ=1

'*******************************************************
Public Function Interp_Move6(ByVal pulse1 As Long, ByVal pulse2 As Long, ByVal pulse3 As Long, ByVal pulse4 As Long, ByVal pulse5 As Long, ByVal pulse6 As Long) As Integer
    
    Result = inp_move6(0, pulse1, pulse2, pulse3, pulse4, pulse5, pulse6)
    
    Interp_Move6 = Result
    
End Function

'******************* Stop the drive functions ********************
'This function is used to stop driving divided into immediate stop and slow down to stop
'parameter: axis-axis number, mode: 0 - stop, 1 - deceleration stop
' return value = 0 correct, an error return value = 1
'*******************************************************
Public Function StopRun(ByVal axis As Integer, ByVal mode As Integer) As Integer

    If mode = 0 Then
        
        Result = sudden_stop(0, axis)
        
    Else
    
        Result = dec_stop(0, axis)
    
    End If
    
    StopRun = Result

End Function

'******************* Set the location function ********************
'This function is used to set the logic position and actual position
'parameter: axis-axis No. setting pos-position' mode
'0 - set the logical location 1 - set the actual position
' return value = 0 correct, an error return value = 1
'*******************************************************
Public Function Setup_Pos(ByVal axis As Integer, ByVal pos As Long, ByVal mode As Integer) As Integer

    If mode = 0 Then
    
        Result = set_command_pos(0, axis, pos)
        
    Else
    
        Result = set_actual_pos(0, axis, pos)
        
    End If
    
End Function

'******************* For sports information function ********************
'This function is used to obtain logical position, actual position and speed
'parameter: axis-axis number, logps-logical location
' actpos-actual position, speed-runs' return value = 0 correct, an error return value = 1
'*******************************************************
Public Function Get_CurrentInf(ByVal axis As Integer, LogPos As Long, actpos As Long, speed As Long) As Integer

    Result = get_command_pos(0, axis, LogPos)
    
    get_actual_pos 0, axis, actpos
    
    get_speed 0, axis, speed
    
    Get_CurrentInf = Result
    
End Function


'*******************Get state of motion function ********************
'This function is used to obtain each axis interpolation driving status and driving status
'parameter: axis-axis number, value-state (0 - drive end, non-0 - is driving)
' mode 0 - for single-axis drive status, non-0 - for plug drive complements the state
'return value = 0 correct, an error return value = 1
'*******************************************************
Public Function Get_MoveStatus(ByVal axis As Integer, ByVal value As Integer, ByVal mode As Integer) As Integer

    If mode = 0 Then
    
        GetMove_Status = get_status(0, axis, value)
        
    Else
    
        GetMove_Status = get_inp_status(0, value)
        
    End If
    
End Function

'*********************** Read input ********************** *********
'' This function is used to read a single entry point '' Parameters: number-input (0 ~ 31) '
' Returns: 0 - low, 1 - high, -1-- error '
'
'****************************************************************
Public Function Read_Input(ByVal number As Integer) As Integer
    
    Read_Input = read_bit(0, number)
    
End Function

'********************* Output single point function ************************ ******
'' This function is used to output a single point of signal '
' Parameters: number-Output (0 ~ 15) 'value 0 - low 1 - high',
'return value = 0 is correct, return Value = 1 error
'****************************************************************
Public Function Write_Output(ByVal number As Integer, ByVal value As Integer) As Integer

    Write_Output = write_bit(0, number, value)
    
End Function


'******************** Set the pulse output mode **********************
'' The function is used to set the pulse work
'' Parameters: axis-axis number, value-pulse mode 0 - pulse + pulse 1 - Pulse + direction method
'' Return Value = 0 correct, an error return value = 1
'' default pulse way for the pulse + direction mode
'' This program uses the default positive logic pulse and direction output signals are logic
'
'*********************************************************
Public Function Setup_PulseMode(ByVal axis As Integer, ByVal value As Integer) As Integer

    Setup_PulseMode = set_pulse_mode(0, axis, value, 0, 0)
    
End Function

'******************** Set the limit signal mode **********************
'' This function is used to set the positive / negative direction limit input signal mode nLMT
'' Parameters: axis - axis No. 'value1 0 - is the effective limit 1 - is the limit invalid
' value2 0 - negative limit effective 1 - Negative limit is invalid
'logic 0 - active LOW 1 - Active High
' default mode is: is the effective limit the negative limit, active-low '
' Return Value = 0 correct, an error return value = 1
'  *********************************************************
Public Function Setup_LimitMode(ByVal axis As Integer, ByVal value1 As Integer, ByVal value2 As Integer, ByVal logic As Integer) As Integer

    Setup_LimitMode = set_limit_mode(0, axis, value1, value2, logic)
    
End Function

'
'******************** Set stop0 signaling **********************
'' The function is used to set the signal mode stop0 '
' Parameters: axis - axis number 'value 0 - invalid 1 - effectively
' logic 0 - active LOW 1 - Active High 'default mode is: Invalid'
'Return Value = 0 correct, an error return value = 1
'  *********************************************************
Public Function Setup_Stop0Mode(ByVal axis As Integer, ByVal value As Integer, ByVal logic As Integer) As Integer

    Setup_Stop0Mode = set_stop0_mode(0, axis, value, logic)
    
End Function


'******************** Set stop1 signaling **********************
'' The function is used to set the signal mode stop1
'' Parameters: axis - axis number 'value 0 - invalid 1 - effectively
' logic 0 - active LOW 1 - Active High 'default mode is: Invalid'
'Return Value = 0 correct, an error return value = 1
'  *********************************************************
Public Function Setup_Stop1Mode(ByVal axis As Integer, ByVal value As Integer, ByVal logic As Integer) As Integer

    Setup_Stop1Mode = set_stop1_mode(0, axis, value, logic)
    
End Function

'******************** Set the hardware to stop **************************
'' This function is used to set the hardware stop mode
'' Parameters: value 0 - invalid 1 - effectively
'logic 0 - active LOW 1 - Active High
' default mode is: Invalid '
' Return Value = 0 correct , the return value = 1 Error in
'hardware terminal stop signal is fixed using the P3 board 34 pin (IN31)
'  *********************************************************

Public Function Setup_HardStop(ByVal value As Integer, ByVal logic As Integer) As Integer

    Setup_HardStop = set_suddenstop_mode(0, value, logic)
    
End Function
'******************** Set delay **************************
'' This function is used to set the delay
'' Parameters: time - delay time (in us)
'' Return Value = 0 correct, an error return value = 1
'  *********************************************************

Public Function Setup_Delay(ByVal time As Long) As Integer

    Setup_Delay = set_delay_time(0, time * 8)
    
End Function

'********************** For delay status **********************
' The delay function is used to obtain the status of
'the return value 0 - delay the end of 1 - Delay in progress
'********************************************************

Public Function Get_DelayStatus() As Integer

    Get_DelayStatus = get_delay_status(0)
    
End Function

'******************** Set common input and output **********************
'the function used to set the general-purpose input-output
'parameters:
' v1 -0: 8 points in front of the input is defined as 1: 8 points in front is defined as the output of
'v2 -0: 8 points behind the definition of the input 1: behind the 8 point is defined as the output of
'return value = 0 correct, an error return value = 1
' Note: When the IO point when used as outputs and can also read the input status
'  *********************************************************/
Public Function Set_IoMode(ByVal v1 As Integer, ByVal v2 As Integer) As Integer
    
    Set_IoMode = set_io_mode(0, v1, v2)

End Function

'/***************************** Axis relative motion *************** ******
'* Function: with reference to the current location to speed up the quantitative move
' * Parameters: 'cardno - card' axis --- Shaft No.
'pulse - pulse
' lspd --- Low
'hspd - - High-speed
'tacc --- acceleration time (unit: seconds)
' return value 0: the right 1: Error
'*******************************************************************/
Public Function Sym_RelativeMove(ByVal axis As Integer, ByVal pulse As Long, ByVal lspd As Long, ByVal hspd As Long, ByVal tacc As Double, ByVal vacc As Long, ByVal mode As Integer) As Integer

    Sym_RelativeMove = symmetry_relative_move(0, axis, pulse, lspd, hspd, tacc, vacc, mode)
    
End Function
'/*************************** Axis absolute Mobile ***************** *******
'* Function: zero reference position to accelerate the quantitative move
' * Parameters: 'cardno - card
' axis --- Shaft No.
'pulse - pulse
' lspd --- Low
'hspd - - High-speed
'tacc --- acceleration time (unit: seconds)
' return value 0: the right 1: Error
'********************************************************************/
Public Function Sym_AbsoluteMove(ByVal axis As Integer, ByVal pulse As Long, ByVal lspd As Long, ByVal hspd As Long, ByVal tacc As Double, ByVal vacc As Long, ByVal mode As Integer) As Integer

    Sym_AbsoluteMove = symmetry_absolute_move(0, axis, pulse, lspd, hspd, tacc, vacc, mode)
    
End Function

'/********************** Relative movement of the two-axis linear interpolation ******************* *
'* Function: with reference to the current location to speed up the linear interpolation
' * Parameters: 'cardno - card' axis1 --- Shaft No. 1 'axis2 --- Shaft No. 2
' pulse1 - Pulse 1
'pulse2 - Pulse 2
'lspd --- slow
' hspd --- high-speed
'tacc --- acceleration time (unit: seconds)
' return value 0: the right 1: Error

'******************************************************************/
Public Function Sym_RelativeLine2(ByVal axis1 As Integer, ByVal axis2 As Integer, ByVal pulse1 As Long, ByVal pulse2 As Long, ByVal lspd As Long, ByVal hspd As Long, ByVal tacc As Double, ByVal vacc As Long, ByVal mode As Integer) As Integer

    Sym_RelativeLine2 = symmetry_relative_line2(0, axis1, axis2, pulse1, pulse2, lspd, hspd, tacc, vacc, mode)
    
End Function

'/******************** Two-axis linear interpolation is absolutely moving ********************* * '* Function: zero reference position to accelerate in a straight line interpolation
' * Parameters:
'cardno - Card
' axis1 --- Shaft No. 1
'axis2 --- Shaft No. 2
' pulse1 - Pulse 1
'pulse2 - Pulse 2
'lspd --- slow
' hspd --- high-speed
'tacc --- speed up the time (unit: seconds)
' return value 0: the right 1: Error
'******************************************************************/
Public Function Sym_AbsoluteLine2(ByVal axis1 As Integer, ByVal axis2 As Integer, ByVal pulse1 As Long, ByVal pulse2 As Long, ByVal lspd As Long, ByVal hspd As Long, ByVal tacc As Double, ByVal vacc As Long, ByVal mode As Integer) As Integer

    Sym_AbsoluteLine2 = symmetry_absolute_line2(0, axis1, axis2, pulse1, pulse2, lspd, hspd, tacc, vacc, mode)
    
End Function


'/********************** Three-axis linear interpolation relative motion ******************* *
'* Function: reference to the current location, in order to speed up linear interpolation
' * Parameters:
'cardno - Card
' axis1 --- Shaft No. 1
'axis2 --- Shaft No. 2
' axis3 --- Shaft No. 3
'pulse1 - Pulse 1
'pulse2 - Pulse 2
' pulse3 - Pulse 3
'lspd --- slow
' hspd --- high-speed
'tacc --- speed up the time (unit: seconds)
' 'Return value 0: the right 1: Error
'******************************************************************/
Public Function Sym_RelativeLine3(ByVal axis1 As Integer, ByVal axis2 As Integer, ByVal axis3 As Integer, ByVal pulse1 As Long, ByVal pulse2 As Long, ByVal pulse3 As Long, ByVal lspd As Long, ByVal hspd As Long, ByVal tacc As Double, ByVal vacc As Long, ByVal mode As Integer) As Integer

    Sym_RelativeLine3 = symmetry_relative_line3(0, axis1, axis2, axis3, pulse1, pulse2, pulse3, lspd, hspd, tacc, vacc, mode)
    
End Function

'/********************* Three-axis linear interpolation of absolute motion ******************** *
'function: zero reference position to speed up linear interpolation
' Parameters:
'cardno - Card
' axis1 --- Shaft No. 1
'axis2 --- Shaft No. 2
' axis3 --- Shaft No. 3
'pulse1 - Pulse 1
'pulse2 - Pulse 2
' pulse3 - Pulse 3
'lspd --- slow
' hspd --- high-speed
'tacc --- speed up the time (unit: seconds)'
'Return value 0: the right 1: Error

'******************************************************************/
Public Function Sym_AbsoluteLine3(ByVal axis1 As Integer, ByVal axis2 As Integer, ByVal axis3 As Integer, ByVal pulse1 As Long, ByVal pulse2 As Long, ByVal pulse3 As Long, ByVal lspd As Long, ByVal hspd As Long, ByVal tacc As Double, ByVal vacc As Long, ByVal mode As Integer) As Integer

    Sym_AbsoluteLine3 = symmetry_absolute_line3(0, axis1, axis2, axis3, pulse1, pulse2, pulse3, lspd, hspd, tacc, vacc, mode)
    
End Function

'/***************** Four-axis linear interpolation relative motion ****************
'* Function: reference to the current location, to accelerate in a straight line interpolation
'* Parameters:
' cardno - Card
'axis1 --- Shaft No. 1
' axis2 --- Shaft No. 2
'axis3 --- Shaft No. 3
' axis4 --- Shaft No. 4
'pulse1 - - Pulse 1
'pulse2 - Pulse 2
' pulse3 - Pulse 3
'pulse4 - pulse 4
' lspd --- slow
'hspd --- High Speed
'      tacc---speed up the time (unit: seconds)
'******************************************************/
Public Function Sym_RelativeLine4(ByVal axis1 As Integer, ByVal axis2 As Integer, ByVal axis3 As Integer, ByVal axis4 As Integer, ByVal pulse1 As Long, ByVal pulse2 As Long, ByVal pulse3 As Long, ByVal pulse4 As Long, ByVal lspd As Long, ByVal hspd As Long, ByVal tacc As Double, ByVal vacc As Long, ByVal mode As Integer) As Integer

    Sym_RelativeLine4 = symmetry_relative_line4(0, axis1, axis2, axis3, axis4, pulse1, pulse2, pulse3, pulse4, lspd, hspd, tacc, vacc, mode)
    
End Function
'/***************** absolute motionFour-axis linear interpolation ****************
'* Function: Zero reference position to accelerate in a straight line interpolation
'* Parameters:
' cardno - Card
'axis1 --- Shaft No. 1
' axis2 --- Shaft No. 2
'axis3 --- Shaft No. 3
' axis4 --- Shaft No. 4
'pulse1 - - Pulse 1
'pulse2 - Pulse 2
' pulse3 - Pulse 3
'pulse4 - pulse 4
' lspd --- slow
'hspd --- high-speed
' tacc --- speed up the time (unit: seconds)

'******************************************************/
Public Function Sym_AbsoluteLine4(ByVal axis1 As Integer, ByVal axis2 As Integer, ByVal axis3 As Integer, ByVal axis4 As Integer, ByVal pulse1 As Long, ByVal pulse2 As Long, ByVal pulse3 As Long, ByVal pulse4 As Long, ByVal lspd As Long, ByVal hspd As Long, ByVal tacc As Double, ByVal vacc As Long, ByVal mode As Integer) As Integer

    Sym_AbsoluteLine4 = symmetry_absolute_line4(0, axis1, axis2, axis3, axis4, pulse1, pulse2, pulse3, pulse4, lspd, hspd, tacc, vacc, mode)
    
End Function


'/***************** Axis linear interpolation relative motion ****************
'* Function: reference to the current location, to accelerate in a straight line interpolation
'* Parameters:
' cardno - Card
'axis1 --- Shaft No. 1
' axis2 --- Shaft No. 2
'axis3 --- Shaft No. 3
' axis4 --- Shaft No. 4
'axis5 - - Shaft No. 5
'pulse1 - Pulse 1
' pulse2 - Pulse 2
'pulse3 - Pulse 3
' pulse4 - pulse 4
'pulse5 - Pulse 5
' lspd --- slow
'hspd --- high-speed
' tacc- - acceleration time (unit: seconds
'******************************************************/
Public Function Sym_RelativeLine5(ByVal axis1 As Integer, ByVal axis2 As Integer, ByVal axis3 As Integer, ByVal axis4 As Integer, ByVal axis5 As Integer, ByVal pulse1 As Long, ByVal pulse2 As Long, ByVal pulse3 As Long, ByVal pulse4 As Long, ByVal pulse5 As Long, ByVal lspd As Long, ByVal hspd As Long, ByVal tacc As Double, ByVal vacc As Long, ByVal mode As Integer) As Integer

    Sym_RelativeLine5 = symmetry_relative_line5(0, axis1, axis2, axis3, axis4, axis5, pulse1, pulse2, pulse3, pulse4, pulse5, lspd, hspd, tacc, vacc, mode)

End Function

'/***************** Axis linear interpolation of absolute motion ****************
'* Function: Zero reference position to accelerate in a straight line interpolation
'* Parameters:
' cardno - Card
'axis1 --- Shaft No. 1
' axis2 --- Shaft No. 2
'axis3 --- Shaft No. 3
' axis4 --- Shaft No. 4
'axis5 - - Shaft No. 5
'pulse1 - Pulse 1
' pulse2 - Pulse 2
'pulse3 - Pulse 3
' pulse4 - pulse 4
'pulse5 - Pulse 5
' lspd --- slow
'hspd --- high-speed
' tacc- - acceleration time (unit: seconds)
'******************************************************/
Public Function Sym_AbsoluteLine5(ByVal axis1 As Integer, ByVal axis2 As Integer, ByVal axis3 As Integer, ByVal axis4 As Integer, ByVal axis5 As Integer, ByVal pulse1 As Long, ByVal pulse2 As Long, ByVal pulse3 As Long, ByVal pulse4 As Long, ByVal pulse5 As Long, ByVal lspd As Long, ByVal hspd As Long, ByVal tacc As Double, ByVal vacc As Long, ByVal mode As Integer) As Integer

    Sym_AbsoluteLine5 = symmetry_absolute_line5(0, axis1, axis2, axis3, axis4, axis5, pulse1, pulse2, pulse3, pulse4, pulse5, lspd, hspd, tacc, vacc, mode)
    
End Function



'/***************** Six-axis linear interpolation relative motion ****************
'* Function: reference to the current location, to accelerate in a straight line interpolation
'* Parameters:
' cardno - card number
'pulse1 - Pulse 1
' pulse2 - Pulse 2
'pulse3 - Pulse 3
' pulse4 - pulse 4
'pulse5 - Pulse 5
' pulse6 - Pulse 6
'lspd --- slow
' hspd --- high-speed
'tacc --- speed up the time (unit: seconds)
'******************************************************/
Public Function Sym_RelativeLine6(ByVal pulse1 As Long, ByVal pulse2 As Long, ByVal pulse3 As Long, ByVal pulse4 As Long, ByVal pulse5 As Long, ByVal pulse6 As Long, ByVal lspd As Long, ByVal hspd As Long, ByVal tacc As Double, ByVal vacc As Long, ByVal mode As Integer) As Integer

      Result = symmetry_relative_line6(0, pulse1, pulse2, pulse3, pulse4, pulse5, pulse6, lspd, hspd, tacc, vacc, mode)
  
     Sym_RelativeLine6 = Result
     
End Function
 

'/***************** Six-axis linear interpolation of absolute motion ****************
'* Function: Zero reference position to accelerate in a straight line interpolation
'* Parameters:
' cardno - card number
'pulse1 - Pulse 1
' pulse2 - Pulse 2
'pulse3 - Pulse 3
' pulse4 - pulse 4
'pulse5 - Pulse 5
' pulse6 - Pulse 6
'lspd --- slow
' hspd --- high-speed
'tacc --- speed up the time (unit: seconds)
'******************************************************/
Public Function Sym_AbsoluteLine6(ByVal pulse1 As Long, ByVal pulse2 As Long, ByVal pulse3 As Long, ByVal pulse4 As Long, ByVal pulse5 As Long, ByVal pulse6 As Long, ByVal lspd As Long, ByVal hspd As Long, ByVal tacc As Double, ByVal vacc As Long, ByVal mode As Integer) As Integer

       Result = symmetry_absolute_line6(0, pulse1, pulse2, pulse3, pulse4, pulse5, pulse6, lspd, hspd, tacc, vacc, mode)
 
        Sym_AbsoluteLine6 = Result
    
End Function


'/************************************************ *****
'features: access to the output points
' parameters:
' cardno card number
'number output point
' return value Return value: the current state of specified port, said parameter error -1
'*****************************************************/
Public Function Get_OutNum(ByVal number As Integer) As Integer

    Result = get_out(0, number)
    
    Get_OutNum = Result
    
End Function

'******************** External signal quantitatively driven ************************* **********************
'function: external signal quantitatively driven functions
' parameters:
'cardno Card
' axis axis No.
'pulse Pulse
' return value 0: correct 1: Error
'Note: (1) a quantitative pulse, but the driver did not immediately need to wait until the external signal level changes
' (2) you can use the normal buttons, you can also take over the wheel

'******************************************************************/
Public Function Manu_Pmove(ByVal axis As Integer, ByVal pulse As Long) As Integer

    Result = manual_pmove(0, axis, pulse)
    
    Manu_Pmove = Result
    
End Function

'************************ External signal continuous drive function ******************** **
'function: external signal continuous drive function
' parameter:
'cardno Card
' axis axis number
'return value 0: the right 1: Error
' Note: (1) a quantitative pulse, but the driver did not immediately need to wait until the external signal level change
'(2) you can use ordinary button, you can also take over the wheel
'******************************************************************/
Public Function Manu_Continue(ByVal axis As Integer) As Integer

    Result = manual_continue(0, axis)
    
    Manu_Continue = Result

End Function

'*********************** Close external signal drives enable ******************** ***
'function: Close external signal drives enable
' parameter:
'cardno Card
' axis axis number
'return value 0: the right 1: Error
'******************************************************************/
Public Function Disable_Manu(ByVal axis As Integer) As Integer

   Result = manual_disable(0, axis)

   Disable_Manu = Result

End Function

'------------------------ Position latch function --------------------- -----
'Note: When the latch signal is triggered, the current position encoder immediately caught. This feature is used for position measurement is very accurate and convenient.
'------------------------------------------------- Get latch state ********** ----------
'************************* *************
'features: access to latch status
' parameter:
' cardno Card
'axis axis No.
' status-0 | non-implementation of latch state
'1 | performed latch state' Return value 0: Correct 1: Error
'Description: Use this function to capture whether the implementation of the latch position
'******************************************************************/
Public Function Get_LockStatus(ByVal axis As Integer, status As Integer) As Integer

    Result = get_lock_status(0, axis, status)
 
    Get_LockStatus = Result
    
End Function

'**************************** Position latch set function **************** ******
'Function: Set the signal function in place, lock all the axes of the logical location and actual location
' parameter: 'axis-reference axis' mode-position latch mode | 0: Invalid
'| 1: Effective' regi - Counter Mode | 0: logical location '| 1: the physical location of
' logical-level signal | 0: high to low
'| 1: from low to high
' return value 0: the right 1: Error
'Description: Use the specified axis axis of the IN signal as a trigger signal
'*******************************************************************/
Public Function Setup_LockPosition(ByVal axis As Integer, ByVal mode As Integer, ByVal regi As Integer, ByVal logical As Integer) As Integer
    
    Result = set_lock_position(0, axis, mode, regi, logical)
    
    Setup_LockPosition = Result
    
End Function


'************************** Get locked position ******************* *******
'features: access to the locked position' parameter:
'cardno Card' axis axis No.
'pos latched position
' return value 0: the right 1: Error
'******************************************************************
Public Function Get_LockPosition(ByVal axis As Integer, pos As Long) As Integer

    Result = get_lock_position(0, axis, pos)
    
    Get_LockPosition = Result
    
End Function

'************************** Clear latch state ******************* *******
'Function: Clear latched status
' parameter:
' cardno Card
'axis axis number (1 - 4)' return value 0: the right 1: Error
'******************************************************************
Public Function Clr_LockStatus(ByVal axis As Integer) As Integer

    Result = clr_lock_status(0, axis)
    
    Clr_LockStatus = Result
    
End Function






